﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;
using RecoderProject;

namespace RevisionAnalyser.Projects.RecoderProject.Tasks
{
    public class RemoveTask : RecoderTask
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;
        private long _id;

        public RemoveTask(long id)
        {
            _id = id;
        }

        public override void Run()
        {
            try
            {
                RemoveRevision();
                _project.RevisionSet.DeleteRevision(_id, false);
                AddLog(String.Format("Removed SVN revision {0}", _id), Constants.COLOR_GREEN);
            }
            catch (Exception ex)
            {
                AddLog("Error: " + ex.Message, Constants.COLOR_RED);
            }
            finally
            {
                TaskFinished();
            }
        }

        private void RemoveRevision()
        {
            RecoderAnalyser analyser = GetRecoderAnalyser(_project);
            analyser.RemoveRevision(String.Format("{0}\\Dataset.bin", _project.GetAnalysedFolder()), _id);
        }
    }
}
